%% Procesamiento de Señales Biomédicas
%  Universidad de Granada
%  Grado en Ingeniería Electrónica Industrial
%
%  Tema 2. Electroencefalografía (EEG)
%  Profesor: Joaquín T. Valderrama (jvalderrama@ugr.es)

%% Sección 3.4.1 Independent Component Analysis
clear,clc,close all

% Incluimos el paquete de trabajo Fieldtrip
addpath(genpath('Fieldtrip'))

% Leemos los datos (64 canales)
FileName = 'EEG_Multichan.cnt';             % Nombre del archivo
cfg = [];                                   % variable de configuración
cfg.dataset = FileName;                     % Nombre del archivo
cfg.channel = {'all','-CB1','-CB2','-EKG','-EMG'};  % Selección de canales
data = ft_preprocessing(cfg);               % Lectura de datos
fs = data.fsample;                          % Frecuencia de muestreo

% Visualizar datos en raw
cfg = [];
cfg.viewmode = 'vertical';
cfg.ylim = [-20 20];
cfg.blocksize = 9;
cfg.preproc.hpfilter = 'yes';
cfg.preproc.hpfreq = 1;
cfg.channel = 1:64;
ft_databrowser(cfg,data);

% Lectura de Triggers (eventos)
Triggers = ft_read_event(FileName);
Triggers = ft_filter_event(Triggers,'type','trigger','value',20);
Triggers = Triggers(1:20);
Triggers = [Triggers.sample]';
Prestim = 2.0*fs;        Poststim = (9-2.0)*fs;
Triggers = [Triggers-Prestim Triggers+Poststim -Prestim*ones(length(Triggers),1)];

% Segmentación del EEG en tramas de acuerdo con los Triggers
cfg = [];
cfg.trl = floor(Triggers);
data = ft_redefinetrial(cfg,data);

% Separate independent components using ICA
cfg = [];
cfg.channel = {'all'};
cfg.randomseed = 1;
cfg.numcomponent = 64;                      % Número de canales
cfg.method = 'runica';
data = ft_componentanalysis(cfg,data);      % ICA

% Visualizar componentes independientes
set(0,'DefaultFigureColormap',feval('jet'));
cfg = [];
cfg.layout = 'EEG1010.lay';
cfg.viewmode = 'component';
ft_databrowser(cfg,data);

% Identificar componentes asociadas con la actividad del pestañeo
ICA_ComponentsReject = [1];

% Recomponer los datos excluyendo las componentes asociadas al pestañeo
cfg = [];
cfg.component = ICA_ComponentsReject;
data = ft_rejectcomponent(cfg,data);


%% Sección 4.3. Medir amplitudes y latencias
clear,clc

% Inicialización de variables
h = load('ABR_Template');
ABR = h.ABR;
fs = h.fs;
t = 0:1/fs:(length(ABR)-1)/fs;
FS = 12;

% Generación de la figura
clf(figure(1)),box on
plot(t*1e3,ABR,'LineWidth',2),grid on
axis([0 15 -0.05 0.07])
set(gca,'xtick',0:2:14,'FontSize',FS-2)
xlabel('Tiempo (ms)','FontSize',FS)
ylabel('Amplitud (\muV)','FontSize',FS)
title('ABR de ejemplo')

% Marcamos componentes
gtext('I','FontSize',FS+2)
gtext('III','FontSize',FS+2)
gtext('V','FontSize',FS+2)

% Medimos componentes
M = ginput(6);          % 1.Pico-I, 2.Valle-I, 3.Pico-III, 4.Valle-III...

% Latencias
L1 = M(1,1);
L3 = M(3,1);
L5 = M(5,1);

% Amplitudes
A1 = M(1,2)-M(2,2);
A3 = M(3,2)-M(4,2);
A5 = M(5,2)-M(6,2);

% Mostramos resultados por pantalla.
fprintf(sprintf('LI = %1.1f ms\t\tLIII = %1.1f ms\t\tLV = %1.1f ms\n',...
    L1,L3,L5))
fprintf(sprintf('AI = %1.3f uV\tAIII = %1.3f uV\t\tAV = %1.3f uV\n\n',...
    A1,A3,A5))